//                                               -*- C++ -*-
/**
 *  @file  TestQuadraticCumul.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: TestQuadraticCumul.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include <cmath>
#include <iostream>
#include <cstdlib>
#include "OTconfig.hxx" // Only needed for test wrappers
#include "WrapperInterface.h"
#include "WrapperCommon.h"
#include "WrapperMacros.h"

namespace WrapperInternals {
  struct internalState {
    long numberOfCalls;
  };

  void internalStateInitialization(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls = 0;
  }

  void internalStateIncrement(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls++;
  }

  long internalStateGetNumberOfCalls(struct internalState * p_internalState)
  {
    return (p_internalState ? p_internalState->numberOfCalls : -1);
  }
} /* namespace WrapperInternals */

#define WRAPPERNAME TestQuadraticCumul

extern "C" {

  static struct WrapperInformation info_TestQuadraticCumul = {/* inSize_  = */ 2,
                                                              /* outSize_ = */ 1};


  /* Function */
  FUNC_CREATESTATE( WRAPPERNAME ,
                    {
                      *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
                      internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
                    } )

  FUNC_DELETESTATE( WRAPPERNAME , { free(p_state); } )

  FUNC_INFO( WRAPPERNAME , { *p_info = info_TestQuadraticCumul; } )

  FUNC_INIT( WRAPPERNAME , {} )

  FUNC_EXEC( WRAPPERNAME ,
             {
               internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
               double x1(inPoint->data_[0]);
               double x2(inPoint->data_[1]);

               // f1 = (x2+1)*exp(x1-2*x2);
               outPoint->data_[0] = (x2+1)*exp(x1-2*x2);
             } )

  FUNC_FINALIZE( WRAPPERNAME , {} )


  /* Gradient, which is void at this time */
  GRAD_CREATESTATE( WRAPPERNAME ,
                    {
                      *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
                      internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
                    } )

  GRAD_DELETESTATE( WRAPPERNAME , { free(p_state); } )

  GRAD_INFO( WRAPPERNAME , { *p_info = info_TestQuadraticCumul; } )

  GRAD_INIT( WRAPPERNAME , {} )

  GRAD_EXEC( WRAPPERNAME ,
             {
               internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
               double x1(inPoint->data_[0]);
               double x2(inPoint->data_[1]);

               // f1 = (x2+1)*exp(x1-2*x2);
               outMatrix->data_[0] = (x2+1)*exp(x1-2*x2);    // df11 = df1/dx1
               outMatrix->data_[1] = -(2*x2+1)*exp(x1-2*x2); // df21 = df1/dx2
             } )

  GRAD_FINALIZE( WRAPPERNAME , {} )

  /* Hessian, which is void at this time */
  HESS_CREATESTATE( WRAPPERNAME ,
                    {
                      *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
                      internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
                    } )

  HESS_DELETESTATE( WRAPPERNAME , { free(p_state); } )

  HESS_INFO( WRAPPERNAME , { *p_info = info_TestQuadraticCumul; } )

  HESS_INIT( WRAPPERNAME , {} )

  HESS_EXEC( WRAPPERNAME ,
             {
               internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
               double x1(inPoint->data_[0]);
               double x2(inPoint->data_[1]);

               // f1 = (x2+1)*exp(x1-2*x2);
               outTensor->data_[0] = (x2+1)*exp(x1-2*x2);    // d2f111 = d2f1/dx1dx1
               outTensor->data_[1] = -(1+2*x2)*exp(x1-2*x2); // d2f112 = d2f1/dx1dx2
               outTensor->data_[2] = -(1+2*x2)*exp(x1-2*x2); // d2f121 = d2f1/dx2dx1
               outTensor->data_[3] = 4*x2*exp(x1-2*x2);      // d2f122 = d2f1/dx2dx2
             } )

  HESS_FINALIZE( WRAPPERNAME , {} )

} /* end extern "C" */
