//                                               -*- C++ -*-
/**
 *  @file  t_AtomicFunctions_std.cxx
 *  @brief The test file of class AtomicFunctions for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (Thu, 04 Feb 2010) $
 *  Id:      $Id: t_PersistentObject_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */

#include <unistd.h> // sysconf
#include <stdlib.h> // getenv
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTthread.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "AtomicFunctions.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;

#define NB_ITER 1000000

void* threadFunc(void* arg)
{
  //
  AtomicInt * atom = (AtomicInt*) arg;

  int i;
  for( i=0; i<NB_ITER; i++ ) {
    atom->increment();
    atom->decrement();
    atom->fetchAndAdd(1);
  }

  return NULL;
}


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    AtomicInt atom;

#ifndef WIN32
    unsigned int nbThreads = sysconf(_SC_NPROCESSORS_CONF);
#else
    std::istringstream converter(getenv("NUMBER_OF_PROCESSORS"));
    unsigned int nbThreads;
    if (!(converter >> nbThreads)) {
      OSS errorMessage;
      errorMessage << "OT::Base::Common::AtomicFunctions wrong nb of thread!";
      throw TestFailed(errorMessage);
    }
#endif
    nbThreads++;
    pthread_t threadsIds[nbThreads];

    int i;
    for( i=0; i<nbThreads; ++i ) {
      int rc = pthread_create( threadsIds + i, NULL,
                               threadFunc,
                               (void*) &atom );
      if (rc != 0) {
        int j;
        for( j=i-1 ; j>=0 ; --j )
          pthread_kill( threadsIds[j], SIGTERM );
        OSS errorMessage;
        errorMessage << "OT::Base::Common::AtomicFunctions Threads creation failed!";
        throw TestFailed(errorMessage);
      }
    } /* end for */

    for( i=0; i<nbThreads; ++i ) {
      int rc = pthread_join( threadsIds[i], NULL );
      if (rc != 0) {
        OSS errorMessage;
        errorMessage << "OT::Base::Common::AtomicFunctions Threads join failed!";
        throw TestFailed(errorMessage);
      }
    } /* end for */

    int shaked = atom.fetchAndAdd(10);
    if (shaked != (NB_ITER * nbThreads)) {
      OSS errorMessage;
      errorMessage << "OT::Base::Common::AtomicFunctions does NOT return the correct value (value="
                   << shaked << " should be " << NB_ITER * nbThreads << ").";
      throw TestFailed(errorMessage);
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
