//                                               -*- C++ -*-
/**
 *  @file  t_BoundConstrainedAlgorithmImplementationResult_std.cxx
 *  @brief The test file of BoundConstrainedAlgorithmImplementationResult class
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-01-08 13:33:24 +0100 (jeu. 08 janv. 2009) $
 *  Id:      $Id: t_BoundConstrainedAlgorithmImplementationResult_std.cxx 1061 2009-01-08 12:33:24Z dutka $
 */
#include <iostream>
#include <iomanip>
#include <cmath>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "BoundConstrainedAlgorithmImplementationResult.hxx"
#include "NumericalPoint.hxx"
#include "OStream.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Optim;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    UnsignedLong dim(4);
    NumericalPoint optimizer(dim, 1.0);
    NumericalScalar optimalValue(5.0);
    BoundConstrainedAlgorithmImplementationResult::OptimizationProblem optimization(BoundConstrainedAlgorithmImplementationResult::MINIMIZATION);
    UnsignedLong evaluationsNumber(10);
    NumericalScalar absoluteError(1e-6);
    NumericalScalar relativeError(1e-7);
    NumericalScalar objectiveError(1e-8);
    NumericalScalar constraintError(1e-10);
    BoundConstrainedAlgorithmImplementationResult result(optimizer, optimalValue, optimization, evaluationsNumber, absoluteError, relativeError, objectiveError, constraintError);
    fullprint << "result=" << result << std::endl;
    fullprint << "minimizer=" << result.getOptimizer() << std::endl;
    fullprint << "optimal value=" << result.getOptimalValue() << std::endl;
    fullprint << "optimization problem=" << (result.getOptimizationProblem() == BoundConstrainedAlgorithmImplementationResult::MINIMIZATION ? "minimization" : "maximization") << std::endl;
    fullprint << "evaluations number=" << result.getEvaluationsNumber() << std::endl;
    fullprint << "absolute error=" << result.getAbsoluteError() << std::endl;
    fullprint << "relativeError=" << result.getRelativeError() << std::endl;
    fullprint << "objective error=" << result.getObjectiveError() << std::endl;
    fullprint << "constraint error=" << result.getConstraintError() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
