//                                               -*- C++ -*-
/**
 *  @file  t_CorrelationAnalysis_std.cxx
 *  @brief Test file fo the correlation coefficients computation
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-04-15 16:24:44 +0200 (mar, 15 avr 2008) $
 *  Id:      $Id:  t_CorrelationAnalysis_sobol.cxx 789 2008-04-15 14:24:44Z lebrun $
 */


#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "Uniform.hxx"
#include "NumericalPoint.hxx"
#include "SymmetricMatrix.hxx"
#include "math.h"
#include "IndependentCopula.hxx"
#include "ComposedDistribution.hxx"
#include "CorrelationAnalysis.hxx"
#include "Matrix.hxx"
#include "LinearNumericalMathFunction.hxx"
#include "Normal.hxx"
#include "Log.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;
using namespace OT::Base::MetaModel;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;


typedef Collection<Distribution> DistributionCollection;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try
    {
      UnsignedLong dimension(2);
      UnsignedLong sampleSize(1000);

      // we create an analytical function
      Description input(dimension);
      input[0] = "x0";
      input[1] = "x1";

      Description foutput("f");

      Description formulas("10+3*x0+x1");

      NumericalMathFunction analytical(input, foutput, formulas);

      // we create a collection of uniform distributions over [-Pi; Pi[
      DistributionCollection aCollection;
      for(UnsignedLong i = 0; i < dimension; ++i)
        {
          aCollection.add(Normal());
        }

      // we create one distribution object
      ComposedDistribution aDistribution(aCollection, IndependentCopula(dimension));

      RandomVector randomVector(aDistribution);
      RandomVector composite(analytical, randomVector);
      fullprint << "composite=" << composite << std::endl;

      // we create two input samples for the function
      NumericalSample inputSample(randomVector.getNumericalSample(sampleSize));
      NumericalSample outputSample(analytical(inputSample));

      NumericalPoint src(CorrelationAnalysis::SRC(inputSample, outputSample));
      fullprint << "src=" << src << std::endl;

    }
  catch (TestFailed & ex)
    {
      std::cerr << ex << std::endl;
      return ExitCode::Error;
    }

  return ExitCode::Success;
}
