//                                               -*- C++ -*-
/**
 *  @file  t_Triangular_std.cxx
 *  @brief The test file of class Triangular for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-08-01 13:42:13 +0200 (Mon, 01 Aug 2011) $
 *  Id:      $Id: t_FiniteDifferenceStep_std.cxx 2060 2011-08-01 11:42:13Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Diff;
using namespace OT::Uncertainty::Distribution;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {
    UnsignedLong dimension( 2 );
    NumericalPoint epsilon( dimension, 1e-5 );
    NumericalPoint eta( dimension, 1.0 );
    Collection<FiniteDifferenceStep> coll;
    coll.add(ConstantStep(epsilon));
    coll.add(BlendedStep(epsilon, eta));
    
    
    NumericalPoint x(dimension, -3.0);
    
    for (UnsignedLong i = 0; i < coll.getSize(); ++ i)
    {
      FiniteDifferenceStep step_i( coll[i] );
      std::cout << "step type=" << step_i.getImplementation()->getClassName()<<" x="<<x<<" epsilon="<<step_i.getEpsilon()<<" step value="<<step_i.operator()(x) << std::endl;
    }
    
    
    FiniteDifferenceStep step( NumericalPoint(3, 1e-4) );
    
    fullprint << "saved  FiniteDifferenceStep=" << step << std::endl;

    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("step", step);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    Triangular triangular;
    myStudy2.fillObject("step", step);
    fullprint << "loaded FiniteDifferenceStep=" << step << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
