//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_exec_sample_no_retry.cxx
 *  @brief The test file of class NumericalMathFunction for failed execution with samples
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2009-09-30 17:51:57 +0200 (Wed, 30 Sep 2009) $
 *  Id:      $Id: t_NumericalMathFunction_exec_sample.cxx 1357 2009-09-30 15:51:57Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalSample.hxx"
#include "Description.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    /** Instance creation */
    NumericalMathFunction deviation("poutre_sample_no_retry");

    UnsignedLong size(10);
    NumericalSample inSample(size, 4);
    NumericalSample outSample1(size,1);
    for(UnsignedLong i = 0; i < size; i++) {
      NumericalScalar fact(1.0 + NumericalScalar(i) / size);
      inSample[i][0] = 210.e9 * fact;
      inSample[i][1] = 1000.0 * fact;
      inSample[i][2] = 1.5 * fact;
      inSample[i][3] = 2.e-6 * fact;
      outSample1[i]  = deviation( inSample[i] );
    }

    fullprint << "outSample by point evaluation=" << outSample1 << std::endl;

    try {
      NumericalSample outSample2( deviation(inSample) );
      fullprint << "outSample by sample evaluation=" << outSample2 << std::endl;
      throw TestFailed( "Sample evaluation should have failed !" );

    } catch (Exception & ex) {
      fullprint << "Sample evaluation expected to fail" << std::endl;
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
