//                                               -*- C++ -*-
/**
 *  @file  t_PersistentObject_std.cxx
 *  @brief The test file of class PersistentObject for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_PersistentObject_std.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "PersistentObject.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;


class TestObject : public PersistentObject
{
public:
  explicit TestObject() : PersistentObject() {}
  explicit TestObject(const String & name) : PersistentObject(name) {}
  virtual ~TestObject() {}
  virtual TestObject * clone() const { return new TestObject(*this); }
};


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    // Test basic functionnalities
    checkClassWithClassName<TestObject>();

    // Test some extra functionnalities
    checkNameFeature<TestObject>();

    // Identity comparison
    TestObject o1, o2;
    if (! o1.is(o1)) {
      OSS errorMessage;
      errorMessage << "OT::Base::Common::PersistentObject.is does NOT return the correct value. Says that object o1 IS NOT o1 !";
      throw TestFailed(errorMessage);
    }

    if (o1.is(o2)) {
      OSS errorMessage;
      errorMessage << "OT::Base::Common::PersistentObject.is does NOT return the correct value. Says that object o1 IS object o2 !";
      throw TestFailed(errorMessage);
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
