//                                               -*- C++ -*-
/**
 *  @file  t_Study_load.cxx
 *  @brief The test file of class Study for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_Study_load.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Study.hxx"
#include "XMLStorageManager.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Beta.hxx"
#include "Matrix.hxx"
#include "LinearModel.hxx"
#include "NearestPointAlgorithm.hxx"
#include "Simulation.hxx"
#include "Beta.hxx"
#include "ComposedDistribution.hxx"
#include "Exponential.hxx"
#include "Gamma.hxx"
#include "Geometric.hxx"
#include "IndependentCopula.hxx"
#include "KernelSmoothing.hxx"
#include "Logistic.hxx"
#include "LogNormal.hxx"
#include "NormalCopula.hxx"
#include "Uniform.hxx"
#include "NumericalMathFunction.hxx"
#include "QuadraticCumul.hxx"
#include "FORM.hxx"
#include "SORM.hxx"
#include "UserDefined.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Func;
using namespace OT::Base::Optim;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Algorithm;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  const char fileName[] = "myXMLFile";

  try {

    // Create a Study Object
    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager(fileName));

    myStudy.load();
    fullprint << "Study = " << myStudy    << std::endl;

    // Create a NumericalPoint from the one stored in the Study
    NumericalPoint point;
    myStudy.fillObject( "Good", point );

    NumericalPoint namedPoint;
    myStudy.fillObjectByName( namedPoint, "point" );

    fullprint << "point = " << point      << std::endl;

    // Create a NumericalSample from the one stored in the Study
    NumericalSample sample;
    myStudy.fillObject( "mySample", sample );

    fullprint << "sample = " << sample      << std::endl;

    //    myStudy.fillObject(sample, 17);

    //    fullprint << "sample = " << sample      << std::endl;

    // Create a Matrix from the one stored in the Study
    Matrix matrix;
    myStudy.fillObject( "m", matrix );

    fullprint << "matrix = " << matrix << std::endl;

    // Create a LinearModel from the one stored in the Study
    LinearModel linearModel;
    myStudy.fillObject( "lm", linearModel );

    fullprint << "linear model = " << linearModel << std::endl;

    // Create a NearestPointAlgorithm::Result from the one stored in the Study
    NearestPointAlgorithm::Result nearestPointAlgorithmResult;
    myStudy.fillObject( "nearestPointAlgorithmResult", nearestPointAlgorithmResult );

    fullprint << "nearestPointAlgorithmResult = " << nearestPointAlgorithmResult << std::endl;

    // Create a SimulationResult from the one stored in the Study
    SimulationResult simulationResult;
    myStudy.fillObject( "simulationResult", simulationResult );

    fullprint << "simulation result = " << simulationResult << std::endl;

    // Create a Beta distribution from the one stored in the Study
    Beta beta;
    myStudy.fillObject( "beta", beta );

    fullprint << "beta = " << beta << std::endl;

    // Create a Exponential distribution from the one stored in the Study
    Exponential exponential;
    myStudy.fillObject( "exponential", exponential );

    fullprint << "exponential = " << exponential << std::endl;

    // Create a Gamma distribution from the one stored in the Study
    Gamma gamma;
    myStudy.fillObject( "gamma", gamma );

    fullprint << "gamma = " << gamma << std::endl;

    // Create a Geometric distribution from the one stored in the Study
    Geometric geometric;
    myStudy.fillObject( "geometric", geometric );

    fullprint << "geometric = " << geometric << std::endl;

    // Create a IndependentCopula distribution from the one stored in the Study
    IndependentCopula independentCopula;
    myStudy.fillObject( "independentCopula", independentCopula );

    fullprint << "independentCopula = " << independentCopula << std::endl;

    // Create a KernelSmoothing algorithm from the one stored in the Study
    KernelSmoothing kernelSmoothing;
    myStudy.fillObject( "kernelSmoothing", kernelSmoothing );

    fullprint << "kernelSmoothing = " << kernelSmoothing << std::endl;

    // Create a Logistic distribution from the one stored in the Study
    Logistic logistic;
    myStudy.fillObject( "logistic", logistic );

    fullprint << "logistic = " << logistic << std::endl;

    // Create a LogNormal distribution from the one stored in the Study
    LogNormal logNormal;
    myStudy.fillObject( "logNormal", logNormal );

    fullprint << "logNormal = " << logNormal << std::endl;

    // Create a NormalCopula distribution from the one stored in the Study
    NormalCopula normalCopula;
    myStudy.fillObject( "normalCopula", normalCopula );

    fullprint << "normalCopula = " << normalCopula << std::endl;

    // Create a Uniform distribution from the one stored in the Study
    Uniform uniform;
    myStudy.fillObject( "uniform", uniform );

    fullprint << "uniform = " << uniform << std::endl;

    // Create a ComposedDistribution distribution from the one stored in the Study
    ComposedDistribution composedDistribution;
    myStudy.fillObject( "composed", composedDistribution );

    fullprint << "composedDistribution = " << composedDistribution << std::endl;

    // Create a UserDefined distribution from the one stored in the Study
    UserDefined userDefined;
    myStudy.fillObject( "userDefined", userDefined );

    fullprint << "userDefined = " << userDefined << std::endl;

    // Create an analytical NumericalMathFunction from the one stored in the Study
    NumericalMathFunction analytical;
    myStudy.fillObject( "analytical", analytical );

    // Create a QuadraticCumul algorithm from the one stored in the Study
    QuadraticCumul quadraticCumul;
    myStudy.fillObject( "quadraticCumul", quadraticCumul );

    fullprint << "quadraticCumul = " << quadraticCumul << std::endl;

    // Create a FORMResult from the one stored in the Study
    FORMResult formResult;
    myStudy.fillObject( "formResult", formResult );

    fullprint << "formResult = " << formResult << std::endl;

    // Create a SORMResult from the one stored in the Study
    SORMResult sormResult;
    myStudy.fillObject( "sormResult", sormResult );

    fullprint << "sormResult = " << sormResult << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }




  return ExitCode::Success;
}
