//                                               -*- C++ -*-
/**
 *  @file  t_TestResult_std.cxx
 *  @brief The test file of class TestResult
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: t_TestResult_std.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "TestResult.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    /** TEST NUMBER ZERO : DEFAULT CONSTRUCTOR AND STRING CONVERTER */
    fullprint << "test number zero : default constructor and string converter" << std::endl;

    /* Default constructor */
    String type = "testResult";
    Bool testBool = 1;
    NumericalScalar testVal = 0.372;
    NumericalScalar testThres = 0.42;
    TestResult testResultTest(type, testBool, testVal, testThres);

    /* String converter */
    fullprint << "testResultTest = " << testResultTest << std::endl;


    /** TEST NUMBER ONE : COPY CONSTRUCTOR AND STRING CONVERTER */
    fullprint << "test number one : copy constructor and string converter" << std::endl;

    /* Copy constructor */
    TestResult testResultTest2(testResultTest);

    /* String converter */
    fullprint << "testResultTest2 = " << testResultTest2 << std::endl;


    /** TEST NUMBER TWO : ELEMENTS ACCESSORS */
    fullprint << "test number two : elements accessors" << std::endl;
    fullprint << "testResultTest2 binary quality measure = " << testResultTest2.getBinaryQualityMeasure() << std::endl;
    fullprint << "testResultTest2 p value = " << testResultTest2.getPValue() << std::endl;
    fullprint << "testResultTest2 p value threshold = " << testResultTest2.getThreshold() << std::endl;
    fullprint << "testResultTest2 test type = " << testResultTest2.getTestType() << std::endl;

    /** TEST NUMBER THREE : EQUALITY */
    fullprint << "testResultTest2 = testResultTest " << (testResultTest2 == testResultTest) << std::endl;
    String typeDiff = "testResult2";
    Bool testBoolDiff = 0;
    NumericalScalar testValDiff = 0.02;
    NumericalScalar testThresDiff = 0.12;
    TestResult testResultTestDiff(typeDiff, testBoolDiff, testValDiff, testThresDiff);
    fullprint << "testResultTestDiff = testResultTest " << (testResultTestDiff == testResultTest) << std::endl;

    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("result", testResultTest);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    TestResult result;
    myStudy2.fillObject("result", result);
    fullprint << "loaded TestResult=" << result << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
