// SWIG file HistogramPair.i
// Author : $LastChangedBy: lebrun $
// Date : $LastChangedDate: 2010-11-21 22:52:28 +0100 (dim. 21 nov. 2010) $
// Id : $Id: HistogramPair.i 1658 2010-11-21 21:52:28Z lebrun $

%{
#include "HistogramPair.hxx"

  namespace OpenTURNS {

    template <>
      struct traitsPythonType<OpenTURNS::Uncertainty::Distribution::HistogramPair>
      {
        typedef _PyObject_ Type;
      };

    template <>
      inline
      OpenTURNS::Uncertainty::Distribution::HistogramPair *
      buildObjectFromPySequence<OpenTURNS::Uncertainty::Distribution::HistogramPair>(PyObject * pyObj)
      {
        check<_PySequence_>( pyObj );

        const UnsignedLong size = PySequence_Fast_GET_SIZE( pyObj );
        if (size != 2) {
          throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence object has incorrect size " << size << ". Must be 2.";
        }
        PyObject * elt1 = PySequence_Fast_GET_ITEM( pyObj, 0 );
        check<_PyFloat_>( elt1 );
        PyObject * elt2 = PySequence_Fast_GET_ITEM( pyObj, 1 );
        check<_PyFloat_>( elt2 );
        return new OpenTURNS::Uncertainty::Distribution::HistogramPair( convert<_PyFloat_,OpenTURNS::NumericalScalar>( elt1 ),
                                                                        convert<_PyFloat_,OpenTURNS::NumericalScalar>( elt2 ) );
      }

    template <>
      inline
      OpenTURNS::Uncertainty::Distribution::HistogramPair
      convert<_PySequence_,OpenTURNS::Uncertainty::Distribution::HistogramPair>(PyObject * pyObj)
      {
        OpenTURNS::Pointer<OpenTURNS::Uncertainty::Distribution::HistogramPair> ptr = buildObjectFromPySequence<OpenTURNS::Uncertainty::Distribution::HistogramPair>( pyObj );
        return *ptr;
      }

    template <>
      inline
      OpenTURNS::Uncertainty::Distribution::HistogramPair
      convert<_PyObject_,OpenTURNS::Uncertainty::Distribution::HistogramPair>(PyObject * pyObj)
      {
        void * ptr = 0;
        if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Distribution::HistogramPair *"), 0 |  0 ))) {
          OpenTURNS::Uncertainty::Distribution::HistogramPair * p_hp = reinterpret_cast< OpenTURNS::Uncertainty::Distribution::HistogramPair * >( ptr );
          return *p_hp;

        } else if (isAPython<_PySequence_>( pyObj )) {
          return convert<_PySequence_,OpenTURNS::Uncertainty::Distribution::HistogramPair>( pyObj );

        } else {
          throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is neither an HistogramPair nor an object convertible to an HistogramPair";
        }
        return OpenTURNS::Uncertainty::Distribution::HistogramPair();
      }


  } /* namespace OpenTURNS */

  %}

%include HistogramPair.hxx

namespace OpenTURNS { namespace Uncertainty { namespace Distribution { %extend HistogramPair { HistogramPair(const HistogramPair & other) { return new OpenTURNS::Uncertainty::Distribution::HistogramPair(other); } } }}}
