// SWIG file NumericalPointWithDescription.i
// Author : $LastChangedBy: souchaud $
// Date : $LastChangedDate: 2011-04-05 17:50:07 +0200 (Tue, 05 Apr 2011) $
// Id : $Id: NumericalPointWithDescription.i 1855 2011-04-05 15:50:07Z souchaud $

%{
#include "NumericalPointWithDescription.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Type::NumericalPointWithDescription>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Type::NumericalPointWithDescription
  convert<_PySequence_,OpenTURNS::Base::Type::NumericalPointWithDescription>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );
    PyObject * newPyObj = PySequence_Fast( pyObj, "" );

    const OpenTURNS::UnsignedLong size = PySequence_Fast_GET_SIZE( newPyObj );
    OpenTURNS::Base::Type::NumericalPointWithDescription * p_np = new OpenTURNS::Base::Type::NumericalPointWithDescription( size );
    OpenTURNS::Base::Type::Description desc = OpenTURNS::Base::Type::Description( size );

    for(OpenTURNS::UnsignedLong i=0; i<size; ++i) {
      PyObject * elt = PySequence_Fast_GET_ITEM( newPyObj, i );
      check<_PySequence_>( elt );
      if (PySequence_Fast_GET_SIZE( elt ) == 2) {
        PyObject * item_0 = PySequence_Fast_GET_ITEM( elt, 0 );
        check<_PyString_>( item_0 );
        desc[i] = convert<_PyString_,OpenTURNS::String>( item_0 );
        PyObject * item_1 = PySequence_Fast_GET_ITEM( elt, 1 );
        check<_PyFloat_>( item_1 );
        (*p_np)[i] = convert<_PyFloat_,OpenTURNS::NumericalScalar>( item_1 );
      } else throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence item " << i << " passed as argument is not a pair (String, NumericalScalar)";
    }

    Py_XDECREF( newPyObj );
    p_np->setDescription( desc );
    return *p_np;
  }


} /* namespace OpenTURNS */

%}

%rename(NumericalPointWithDescription_operator___eq__) OpenTURNS::Base::Type::operator ==(const NumericalPointWithDescription & lhs, const NumericalPointWithDescription & rhs);

%include NumericalPointWithDescription.hxx
namespace OpenTURNS{ namespace Base { namespace Type {

%extend NumericalPointWithDescription {

NumericalPointWithDescription(const NumericalPointWithDescription & other)
{
  return new OpenTURNS::Base::Type::NumericalPointWithDescription(other);
}


NumericalPointWithDescription(PyObject * pyObj)
{
  return new OpenTURNS::Base::Type::NumericalPointWithDescription( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPointWithDescription>(pyObj) );
}

}
}}}

%template(NumericalPointWithDescriptionCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Type::NumericalPointWithDescription>;
%template(NumericalPointWithDescriptionPersistentCollection) OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Base::Type::NumericalPointWithDescription>;
