// SWIG file OTtypes.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2011-01-12 12:25:16 +0100 (Wed, 12 Jan 2011) $
// Id : $Id: OTtypes.i 1689 2011-01-12 11:25:16Z dutka $

%module types

%include std_string.i
%include std_map.i
%include std_complex.i

%include OT.hxx
%include OTtypes.hxx
%include OTdebug.h

%{
#include "OT.hxx"
#include "PythonWrappingFunctions.hxx"
%}

typedef OpenTURNS::FileName          FileName;
typedef OpenTURNS::String            String;
typedef OpenTURNS::Bool              Bool;
typedef OpenTURNS::NumericalScalar   NumericalScalar;
typedef OpenTURNS::NumericalComplex  NumericalComplex;
typedef OpenTURNS::Id                Id;
typedef OpenTURNS::PointInSourceFile PointInSourceFile;

%typemap(in) NumericalScalar {
  $1 = PyFloat_AsDouble($input);
}

%typemap(in) NumericalComplex {
  $1 = Complex(PyFloat_AsDouble($input.real()), PyFloat_AsDouble($input.imag()));
}

%typemap(out) NumericalComplex {
    $result = complex(PyFloat_FromDouble($1.real()), PyFloat_FromDouble($1.imag()));
}



%ignore *::clone() const;
%ignore *::load(StorageManager::Advocate & adv);
%ignore *::save(StorageManager::Advocate & adv) const;
%ignore *::save(StorageManager & mgr, const String & label, bool fromStudy) const;
%ignore *::save(StorageManager & mgr, const String & label) const;
%ignore *::save(StorageManager & mgr, bool fromStudy) const;
%ignore *::save(StorageManager & mgr) const;
