// SWIG file isoprobabilistictransformation_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-06 12:03:57 +0200 (Wed, 06 Jul 2011) $
// Id : $Id: isoprobabilistictransformation_module.i 1991 2011-07-06 10:03:57Z schueller $

%module(package="openturns", docstring="Iso-probabilictic transformations.") isoprobabilistictransformation
#pragma SWIG nowarn=302,509
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTBase.hxx"
#include "OTModel.hxx"
#include "OTDistribution.hxx"
#include "OTIsoProbabilisticTransformation.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%import common_module.i
%include TestResult.i
%import base_module.i

/* Uncertainty/Model */
/* Uncertainty/Distribution */
%import model_copula_module.i
%import UncertaintyModelCopulaTemplateDefs.i

/* Uncertainty/Algorithm/IsoProbabilisticTransformation */
%include MarginalTransformationEvaluation.i
%include MarginalTransformationGradient.i
%include MarginalTransformationHessian.i
%include NatafEllipticalCopulaEvaluation.i
%include NatafEllipticalCopulaGradient.i
%include NatafEllipticalCopulaHessian.i
%include InverseNatafEllipticalCopulaEvaluation.i
%include InverseNatafEllipticalCopulaGradient.i
%include InverseNatafEllipticalCopulaHessian.i
%include NatafIndependentCopulaEvaluation.i
%include NatafIndependentCopulaGradient.i
%include NatafIndependentCopulaHessian.i
%include InverseNatafIndependentCopulaEvaluation.i
%include InverseNatafIndependentCopulaGradient.i
%include InverseNatafIndependentCopulaHessian.i
%include NatafEllipticalDistributionEvaluation.i
%include NatafEllipticalDistributionGradient.i
%include NatafEllipticalDistributionHessian.i
%include InverseNatafEllipticalDistributionEvaluation.i
%include InverseNatafEllipticalDistributionGradient.i
%include InverseNatafEllipticalDistributionHessian.i
%include RosenblattEvaluation.i
%include InverseRosenblattEvaluation.i


/* At last we include template definitions */
%include UncertaintyIsoProbabilisticTransformationTemplateDefs.i
