"dtnorm" <-
function(x, mean=0, sd=1, lower=-Inf, upper=Inf)
  {
      # Taken from the "msm" package by C. H. Jackson, available on CRAN
      ret <- numeric(length(x))
      ret[x < lower | x > upper] <- 0
      ind <- x >=lower & x <=upper
      if (any(ind)) {
          denom <- pnorm(upper, mean, sd) - pnorm(lower, mean, sd)
          xtmp <- dnorm(x[ind], mean, sd) / denom
          ret[ind] <- xtmp[ind]
      }
      ret
  }

