#                                               -*- Autoconf -*-
#
#  ot_check_tbb.m4
#
#  (C) Copyright 2005-2012 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: schueller $
#  @date:   $LastChangedDate: 2009-09-30 17:51:57 +0200 (Wed, 30 Sep 2009) $
#  Id:      $Id: ot_check_tbb.m4 1357 2009-09-30 15:51:57Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether TBB is available on the
#  build platform.
#
# OT_CHECK_TBB( [TBB_INSTALL_PATH = /usr] )
# -----------------------------------------
#
AC_DEFUN([OT_CHECK_TBB],
[
 AC_ARG_WITH([tbb],
  AC_HELP_STRING([--with-tbb@<:@=DIR@:>@], [add TBB support. @<:@]m4_default([$1], /usr)[@:>@]),
                 [withval_tbb=$withval], [withval_tbb=yes])

 AC_ARG_WITH([tbb-incdir],
  AC_HELP_STRING([--with-tbb-incdir@<:@=DIR@:>@], [Set TBB include directory @<:@]m4_default([$1], /usr/include)[@:>@]),
                 [withval_incdir=$withval], [withval_incdir=yes])

 AC_ARG_WITH([tbb-libdir],
  AC_HELP_STRING([--with-tbb-libdir@<:@=DIR@:>@], [Set TBB library directory @<:@]m4_default([$1], /usr/lib/tbb)[@:>@]),
                 [withval_libdir=$withval], [withval_libdir=yes])

  WITH_TBB=0

  # saving values for compilation variables
  saved_CPPFLAGS=$CPPFLAGS
  saved_LDFLAGS=$LDFLAGS
  saved_LIBS=$LIBS

  tbb_default_path=m4_default([$1], /usr)
  if ! test x${withval_tbb} = xno
  then
    # ask for TBB support
    AC_MSG_NOTICE([checking whether TBB is here and working])

    # we're trying to find the correct TBB installation path
    tbb_install_path=$tbb_default_path
    test x${withval_tbb} = xyes || tbb_install_path=$withval_tbb

    AC_MSG_CHECKING([TBB install path])
    test -d ${tbb_install_path} || AC_MSG_WARN([$tbb_install_path: incorrect path])
    AC_MSG_RESULT([$tbb_install_path])



    # we test the header file presence and usability
    if test x${withval_incdir} = xyes
    then
      tbb_include_path=$tbb_install_path/include
    else
      tbb_include_path=$withval_incdir
    fi
    TBB_CPPFLAGS="-I${tbb_include_path}"
    CPPFLAGS="${CPPFLAGS} ${TBB_CPPFLAGS}"
    AC_LANG_PUSH(C++)
    AC_CHECK_HEADERS([tbb/tbb.h],
                     [tbb_header_found=yes],
                     [tbb_header_found=no],
                     [])
    AC_LANG_POP(C++)
    test x${tbb_header_found} = xno && AC_MSG_WARN([TBB include file NOT FOUND])
    AC_SUBST(TBB_CPPFLAGS)


    # we test the library file presence and usability
    if test x${withval_libdir} = xyes
    then
      tbb_lib_path=$tbb_install_path/lib/tbb
    else
      tbb_lib_path=$withval_libdir
    fi
    tbb_lib_name=tbb
    TBB_LDFLAGS="-L${tbb_lib_path}"
    TBB_LIBS="-l${tbb_lib_name}"
    LDFLAGS="${LDFLAGS} ${TBB_LDFLAGS}"
    LIBS="${LIBS} ${TBB_LIBS}"
    AC_LANG_PUSH(C++)
    AC_LINK_IFELSE([AC_LANG_PROGRAM([[#include <tbb/task_scheduler_init.h>]],
                                    [[tbb::task_scheduler_init scheduler();]])
                   ],
                   [tbb_lib_found=yes],
                   [tbb_lib_found=no])
    AC_LANG_POP(C++)
    test x${tbb_lib_found} = xno && AC_MSG_WARN([TBB library NOT FOUND])
    # The -R libtool option is for rpath
    TBB_LTLDFLAGS="-R${tbb_lib_path}"
    AC_SUBST(TBB_LDFLAGS)
    AC_SUBST(TBB_LTLDFLAGS)
    AC_SUBST(TBB_LIBS)
  fi

  if test x${tbb_header_found} = xyes && test x${tbb_lib_found} = xyes
  then
    # after all tests are successful, we support TBB
    WITH_TBB=1
    AC_MSG_NOTICE([TBB support is OK])

    # Propagate into source files
    AC_DEFINE(HAVE_TBB, [1], [Support for TBB library])

  else
    # no Tbb support
    AC_MSG_NOTICE([No TBB support])
  fi

  # Propagate test into atlocal
  AC_SUBST(WITH_TBB)

  # Propagate test into Makefiles
  AM_CONDITIONAL(WITH_TBB, test $WITH_TBB = 1)


  # restoring saved values
  CPPFLAGS=$saved_CPPFLAGS
  LDFLAGS=$saved_LDFLAGS
  LIBS=$saved_LIBS

])
