//                                               -*- C++ -*-
/**
 *  @file  CopulaImplementation.hxx
 *  @brief Abstract top-level class for all copula
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: CopulaImplementation.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_COPULAIMPLEMENTATION_HXX
#define OPENTURNS_COPULAIMPLEMENTATION_HXX

#include "OTprivate.hxx"
#include "ContinuousDistribution.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class CopulaImplementation
 *
 * A subclass for Continuous usual distributions.
 */
class CopulaImplementation
  : public ContinuousDistribution
{
  CLASSNAME;
public:

  /** Default constructor */
  explicit CopulaImplementation(const String & name = DefaultName);

  /** Virtual constructor */
  virtual CopulaImplementation * clone() const;

  /** Comparison operator */
  Bool operator ==(const CopulaImplementation & other) const;

  /** Get the mean of the distribution */
  NumericalPoint getMean() const;

  /** Get the standard deviation of the distribution */
  NumericalPoint getStandardDeviation() const;

  /** Get the skewness of the distribution */
  NumericalPoint getSkewness() const;

  /** Get the kurtosis of the distribution */
  NumericalPoint getKurtosis() const;

  /** Get the i-th marginal distribution */
  using ContinuousDistribution::getMarginal;
#ifndef SWIG
  CopulaImplementation * getMarginal(const UnsignedLong i) const;
#endif

  /** Get the copula of a distribution */
  Implementation getCopula() const;

  /** String converter */
  String __repr__() const;


  /* Methods inherited from upper classes */

  /** Generic implementation of the quantile computation for continuous distributions */
  NumericalPoint computeQuantile(const NumericalScalar prob,
                                 const Bool tail = false) const;

  /** Get the mathematical and numerical range of the distribution.
      Its mathematical range is the smallest closed interval outside
      of which the PDF is zero, and the numerical range is the interval
      outside of which the PDF is rounded to zero in double precision */
  Interval getRange() const;

  /** Draw the PDF of the copula when its dimension is 2 */
  using ContinuousDistribution::drawPDF;
  Graph drawPDF(const NumericalPoint & pointNumber) const;

  /** Draw the CDF of the copula when its dimension is 2 */
  using ContinuousDistribution::drawCDF;
  Graph drawCDF(const NumericalPoint & pointNumber) const;

protected:

  /** Compute the covariance of the distribution */
  void computeCovariance() const;


private:

}; /* class CopulaImplementation */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_COPULAIMPLEMENTATION_HXX */
