//                                               -*- C++ -*-
/**
 *  @file  t_Domain_std.cxx
 *  @brief The test file of class Domain for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_Domain_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Interval.hxx"
#include "Domain.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    // The 1D interface
    UnsignedLong dim(2);
    NumericalPoint a(dim, -1.0);
    NumericalPoint b(dim, 2.0);
    Domain domain  = Interval(a, b);
    NumericalPoint p1(dim, 0.5);
    NumericalPoint p2(dim, 2.5);
    fullprint << "Domain= " << domain << std::endl;
    // Accessors
    fullprint << "Dimension= " << domain.getDimension() << std::endl;
    // Contains
    fullprint << "is point " << p1 << " inside " << domain << "? " << (domain.contains(p1) ? "yes":"no") << std::endl;
    fullprint << "is point " << p2 << " inside " << domain << "? " << (domain.contains(p2) ? "yes":"no") << std::endl;


    /* Test save / load */
    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("domain", domain);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    Domain myDomainLoaded;
    myStudy2.fillObject("domain", myDomainLoaded);
    fullprint << "loaded domain =" << myDomainLoaded << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
