# -*- coding: utf-8 -*-
#                                               -*- Python -*-
#
# @file  controlwindow.py
# @brief The definition of the window that control all the other windows
#
# (C) Copyright 2005-2012 EDF-EADS-Phimeca
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# @author: $LastChangedBy: schueller $
# @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
# Id:      $Id: controlwindow.py 2392 2012-02-17 18:35:43Z schueller $

from PyQt4.QtCore import *
from PyQt4.QtGui import *

class ControlWindow(QWidget):
    def __init__(self, parent = None):
        QWidget.__init__(self, parent)

        self.windowsList = []

        self.setWindowTitle(self.__tr("OpenTURNS"))

        self.widgetLayout = QVBoxLayout(self)

        self.btnCloseAll = QPushButton(self.__tr("Close All"), self)
        self.connect(self.btnCloseAll, SIGNAL("clicked()"), self.btnCloseAllClicked)
        self.widgetLayout.addWidget(self.btnCloseAll)

    def addImageWindow(self, win):
        self.windowsList.append(win)
        self.connect(win, SIGNAL("winClosed(PyQt_PyObject)"), self.imageWindowClosed)

    def imageWindowClosed(self, win):
        self.windowsList.remove(win)
        if(len(self.windowsList) == 0):
            self.close()

    def btnCloseAllClicked(self):
        for win in self.windowsList[:]:
            win.close()

        self.close()

    def __tr(self, s, c = None):
        return qApp.translate("ControlWindow", s, c)
