#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :

    # Realization issued from a SpectralProcess
    dimension = 1

    # Parameters of the distribution
    N = 51
    t0 = 0.
    dt = 0.1
    myTimeGrid = RegularGrid(t0, dt, N)
    
    # Create a NumericalSample
    # parameters of gaussien impose a few risk to get negative values
    mySample = Uniform().getNumericalSample(N)

    # get a realization from distribution
    myRealization= TimeSeries(myTimeGrid, mySample)
    
    # Create the lambda parameter 
    lambdaVector = NumericalPoint(dimension)
    for index in range(dimension):
      lambdaVector[index] = (index + 2.) * 0.1
    
    myInverseBoxCox = InverseBoxCoxTransform(lambdaVector)

    print  "myInverseBoxCox=" , myInverseBoxCox 
    
    # Get the input and output dimension 
    print  "myInverseBoxCox input dimension = " , myInverseBoxCox.getInputDimension() 
    print  "myInverseBoxCox output dimension = " , myInverseBoxCox.getOutputDimension() 
    
    # Evaluation of the InverseBoxCoxTransform on the realization
    print  "input time series =\n" , myRealization 
    print  "output time series = \n" , myInverseBoxCox(myRealization) 
    
    # Call the getInverse method
    myBoxCox = myInverseBoxCox.getInverse()
    print "myBoxCox = ", myBoxCox

    # Get the number of calls 
    print  "number of call(s) : " , myInverseBoxCox.getCallsNumber() 

except :
    import sys
    print "t_InverseBoxCoxTransform_std.py", sys.exc_type, sys.exc_value
