#                                               -*- Python -*-
#
#  @file  test_wcode.py
#  @brief A test file for the wrapper code
#
#  (C) Copyright 2005-2012 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2007-10-05 23:15:55 +0200 (ven, 05 oct 2007) $
#  Id:      $Id: test_wcode.py 556 2007-10-05 21:15:55Z dutka $
#
#  This script imports the OpenTURNS environment in Python, loads
#  ths wrapper and the wrapped code, and then calls it.
#
from openturns import *

# If you encounter difficulties with wrapper, uncomment the following command and look at the log
#Log.Show( Log.Flags() + Log.WRAPPER )

f = NumericalMathFunction("wcode")
print "f = ", f

inP = NumericalPoint(f.getInputDimension())
for j in range(inP.getDimension()):
    inP[j] = 10. * (j + 1)
print "inP = ", inP

outP = f(inP)
print "outP = ", outP

N = 10
inS = NumericalSample(N, f.getInputDimension())
for i in range(N):
    for j in range(inP.getDimension()):
        inS[i,j] = 1. * i + 10. * (j + 1)
print "inS = ", inS

outS = f(inS)
print "outS = ", outS


