/* OpenVAS-Client
 * $Id$
 * Description: The about information dialog.
 *
 * Authors:
 * Thomas Arendsen Hein <thomas.arendsen.hein@intevation.de>
 *
 * Copyright:
 * Copyright (C) 2007 Intevation GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * In addition, as a special exception, you have
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#include <includes.h>
#include "nessus_i18n.h"

#ifdef USE_GTK
#include <gtk/gtk.h>
#include <corevers.h>
#include "globals.h"

#include "xpm/OpenVAS-logo.xpm"
#include "xpm/logo_intevation.xpm"
#include "xpm/logo_bsi.xpm"
#ifdef HAVE_GNU_GETTEXT
# include "xpm/logo_bsi_de.xpm"
#endif


static void
about_add_text(box, text)
  GtkWidget *box;
  const char *text;
{
  GtkWidget *label;

  label = gtk_label_new(text);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_label_set_selectable(GTK_LABEL(label), TRUE);
}

static void
about_add_logo(box, xpm, alt_text, url)
  GtkWidget *box;
  char **xpm;
  const char *alt_text;
  const char *url;
{
  GtkWidget *vbox;
  GdkPixbuf *pixbuf = NULL;
  GtkWidget *img = NULL;

  vbox = gtk_vbox_new(FALSE, 4);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(box), vbox, FALSE, FALSE, 0);

  if(F_show_pixmaps)
  {
    pixbuf = gdk_pixbuf_new_from_xpm_data((const char **)xpm);
    img = gtk_image_new_from_pixbuf(pixbuf);
    gtk_widget_show(img);
    gtk_box_pack_start(GTK_BOX(vbox), img, FALSE, FALSE, 0);
    gtk_misc_set_alignment(GTK_MISC(img), 0, 0.5);
  }
  else
    about_add_text(vbox, alt_text);

  about_add_text(vbox, url);
}


void
about_dialog(menuitem, ctrls)
  GtkMenuItem *menuitem;
  gpointer ctrls;
{
  GtkWindow *window = GTK_WINDOW(arg_get_value(ctrls, "WINDOW"));
  GtkWidget *dialog;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *vseparator;
  GdkColor bg;
  gchar *text;
  char **bsilogo = logo_bsi_xpm;
#ifdef HAVE_GNU_GETTEXT
  char *lc_messages;
#endif

  dialog = gtk_dialog_new_with_buttons(_("About OpenVAS-Client"),
      window, GTK_DIALOG_DESTROY_WITH_PARENT,
      GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);

  gdk_color_parse("white", &bg);
  gtk_widget_modify_bg(dialog, GTK_STATE_NORMAL, &bg);

  gtk_window_set_transient_for(GTK_WINDOW(dialog), window);
  g_signal_connect(dialog, "response", G_CALLBACK(gtk_widget_destroy), NULL);

  gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);

  hbox = gtk_hbox_new(FALSE, 10);
  gtk_widget_show(hbox);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 10);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox);

  /*
   * left column
   */

  vbox = gtk_vbox_new(FALSE, 12);
  gtk_widget_show(vbox);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), vbox);

  about_add_logo(vbox, OpenVAS_logo_xpm,
      _("OpenVAS"), _("http://www.openvas.org/"));

  text = g_strdup_printf(_("OpenVAS-Client %s"
	"\nNessusClient origin: Copyright 1998-2007 Renaud Deraison"
	"\nNew code since OpenVAS-Client: Copyright 2007, 2008, 2009 Intevation GmbH"
	"\nLicense: GNU GPL v2"), NESSUS_FULL_VERSION);
  about_add_text(vbox, text);
  g_free(text);

  about_add_text(vbox, _("Authors:"
	"\n Renaud Deraison"
	"\n Thomas Arendsen Hein"
	"\n Jan-Oliver Wagner"
	"\n Bernhard Herzog"
	"\n Michel Arboi (SSL Support)"
	"\n Bruce Verderaime (Pie/Charts)"
        "\n Michael Wiegand"
        "\n Felix Wolfsteller"
	));

  /*
   * right column
   */

  vseparator = gtk_vseparator_new();
  gtk_widget_show(vseparator);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), vseparator);

  vbox = gtk_vbox_new(FALSE, 12);
  gtk_widget_show(vbox);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), vbox);

  about_add_text(vbox, _("Supporters:"));

  about_add_logo(vbox, logo_intevation_xpm,
      _("Intevation GmbH"), _("http://www.intevation.net/"));

#ifdef HAVE_GNU_GETTEXT
  lc_messages = setlocale(LC_MESSAGES, NULL);
  if(lc_messages && !strncmp(lc_messages, "de", 2))
    bsilogo = logo_bsi_de_xpm;
#endif
  about_add_logo(vbox, bsilogo,
      _("Federal Office for Information Security"),
      _("http://www.bsi.de/english/"));

  gtk_widget_show(dialog);
}
#endif /* USE_GTK */
