##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import os
import commands
import unittest
from test import sanity_test


class SanityTestCase(unittest.TestCase):
    sanity_test_obj = sanity_test.SanityTest()

    def test_compileScripts1(self):
        print "\nTesting Sanity Test Suite ..."
        req_out_put = None

        cwd = os.getcwd()
        build_path = './test/unit_test/work/input/'
        os.mkdir( build_path + 'sanity_test/')
        os.mkdir( build_path + 'sanity_test/plugins/')

        os_list = ['Nasl']
        openvas_plugin_path = './test/unit_test/work/input/Nasl'

        openvas_bin_path = commands.getoutput('locate -ir bin/openvas-nasl$')

        setattr(self.sanity_test_obj, 'cwd', cwd)
        setattr(self.sanity_test_obj, 'build_path', build_path)
        setattr(self.sanity_test_obj, 'os_list', os_list)
        setattr(self.sanity_test_obj, 'openvas_plugin_path', openvas_plugin_path)
        setattr(self.sanity_test_obj, 'openvas_bin_path', openvas_bin_path)

        out_put = self.sanity_test_obj.compileScripts()
        commands.getoutput('rm -rf ' + build_path + 'sanity_test')
        self.assertEquals(out_put, req_out_put)


    def test_compileScripts2(self):
        req_out_put = None

        cwd = os.getcwd()
        build_path = './test/unit_test/work/input/'
        os.mkdir( build_path + 'sanity_test/')
        os.mkdir( build_path + 'sanity_test/plugins/')

        os_list = ['Nasl']
        openvas_plugin_path = './test/unit_test/work/input/Nasl'
        openvas_bin_path = commands.getoutput('locate -ir bin/openvas-nasl$')

        build_path1 = build_path + '/abc'

        setattr(self.sanity_test_obj, 'cwd', cwd)
        setattr(self.sanity_test_obj, 'build_path', build_path1)
        setattr(self.sanity_test_obj, 'os_list', os_list)
        setattr(self.sanity_test_obj, 'openvas_plugin_path', openvas_plugin_path)
        setattr(self.sanity_test_obj, 'openvas_bin_path', openvas_bin_path)

        out_put = self.sanity_test_obj.compileScripts()
        commands.getoutput('rm -rf ' + build_path + 'sanity_test')
        self.assertNotEquals(out_put, req_out_put)


    def tearDown(self):
        build_path = './test/unit_test/work/input/'
        commands.getoutput('rm -rf ' + build_path + 'sanity_test')


if __name__ == '__main__':
    unittest.main()
