###############################################################################
# OpenVAS Vulnerability Test
# $Id: Chipmunk_guestbook_sql_injection_and_xss.nasl 116 2009-03-10 17:49:48Z mime $
#
# Chipmunk Guestbook Index.PHP SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100039);
 script_bugtraq_id(18195);
 script_cve_id("CVE-2008-6368");
 script_version ("1.0");

 script_name(english:"Chipmunk Guestbook Index.PHP SQL Injection Vulnerability");
 desc["english"] = "

 Overview:
  Chipmunk Guestbook is prone to an SQL-injection vulnerability
  because it fails to properly sanitize user-supplied input before
  using it in an SQL query.

  A successful exploit could allow an attacker to compromise the
  application, access or modify data, or exploit vulnerabilities in
  the underlying database. 

 See also;
  http://www.securityfocus.com/bid/18195

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Chipmunk Guestbook is prone to SQL Injection and Cross Site Scripting");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/guestbook",cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/index.php?start=<script>alert(document.cookie)</script>");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;
 if (
     egrep(pattern:".*You have an error in your SQL syntax.*", string: buf) &&
     egrep(pattern:".*<script>alert\(document.cookie\)</script>.*", string: buf)
    )
     
 	{    
       	  security_warning(port:port);
          exit(0);
        }
}

exit(0);
