# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0205 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63248);
 script_cve_id("CVE-2008-4577", "CVE-2008-4870");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0205";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to Dovecot announced in
advisory RHSA-2009:0205.

A flaw was found in Dovecot's ACL plug-in. The ACL plug-in treated negative
access rights as positive rights, which could allow an attacker to bypass
intended access restrictions. (CVE-2008-4577)

A password disclosure flaw was found with Dovecot's configuration file. If
a system had the ssl_key_password option defined, any local user could
view the SSL key password. (CVE-2008-4870)

Note: This flaw did not allow the attacker to acquire the contents of the
SSL key. The password has no value without the key file which arbitrary
users should not have read access to.

To better protect even this value, however, the dovecot.conf file now
supports the !include_try directive. The ssl_key_password option should
be moved from dovecot.conf to a new file owned by, and only readable and
writable by, root (ie 0600). This file should be referenced from
dovecot.conf by setting the !include_try [/path/to/password/file] option.

Additionally, a number of bug fixes were made (see the referenced
advisories for details).

Users of dovecot are advised to upgrade to this updated package, which
addresses these vulnerabilities and resolves these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0205.html
http://www.redhat.com/security/updates/classification/#low

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0205";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dovecot", rpm:"dovecot~1.0.7~7.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dovecot-debuginfo", rpm:"dovecot-debuginfo~1.0.7~7.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
