# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0256 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63315);
 script_cve_id("CVE-2009-0352", "CVE-2009-0353", "CVE-2009-0354", "CVE-2009-0355", "CVE-2009-0356", "CVE-2009-0357", "CVE-2009-0358");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0256";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0256.

Mozilla Firefox is an open source Web browser.

Several flaws were found in the processing of malformed web content. A web
page containing malicious content could cause Firefox to crash or,
potentially, execute arbitrary code as the user running Firefox.
(CVE-2009-0352, CVE-2009-0353, CVE-2009-0356)

Several flaws were found in the way malformed content was processed. A
website containing specially-crafted content could, potentially, trick a
Firefox user into surrendering sensitive information. (CVE-2009-0354,
CVE-2009-0355)

A flaw was found in the way Firefox treated HTTPOnly cookies. An attacker
able to execute arbitrary JavaScript on a target site using HTTPOnly
cookies may be able to use this flaw to steal the cookie. (CVE-2009-0357)

A flaw was found in the way Firefox treated certain HTTP page caching
directives. A local attacker could steal the contents of sensitive pages
which the page author did not intend to be cached. (CVE-2009-0358)

For technical details regarding these flaws, please see the Mozilla
security advisories for Firefox 3.0.6. You can find a link to the Mozilla
advisories in the References section.

All Firefox users should upgrade to these updated packages, which contain
Firefox version 3.0.6, which corrects these issues. After installing the
update, Firefox must be restarted for the changes to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0256.html
http://www.redhat.com/security/updates/classification/#critical
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.6

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0256";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.6~1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.6~1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.2.0~3.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.2.0~3.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.2.0~3.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-tools", rpm:"nss-tools~3.12.2.0~3.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.6~1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.6~1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.2.0~4.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.2.0~4.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-tools", rpm:"nss-tools~3.12.2.0~4.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9.0.6~1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9.0.6~1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.2.0~4.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-pkcs11-devel", rpm:"nss-pkcs11-devel~3.12.2.0~4.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9.0.6~1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9.0.6~1.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
