# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0331 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63518);
 script_cve_id("CVE-2008-5700", "CVE-2009-0031", "CVE-2009-0065", "CVE-2009-0322");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0331";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to the kernel announced in
advisory RHSA-2009:0331.

This update addresses the following security issues:

* a buffer overflow was found in the Linux kernel Partial Reliable Stream
Control Transmission Protocol (PR-SCTP) implementation. This could,
potentially, lead to a denial of service if a Forward-TSN chunk is received
with a large stream ID. (CVE-2009-0065, Important)

* a memory leak was found in keyctl handling. A local, unprivileged user
could use this flaw to deplete kernel memory, eventually leading to a
denial of service. (CVE-2009-0031, Important)

* a deficiency was found in the Remote BIOS Update (RBU) driver for Dell
systems. This could allow a local, unprivileged user to cause a denial of
service by reading zero bytes from the image_type or packet_size file in
/sys/devices/platform/dell_rbu/. (CVE-2009-0322, Important)

* a deficiency was found in the libATA implementation. This could,
potentially, lead to a denial of service. Note: by default, /dev/sg*
devices are accessible only to the root user. (CVE-2008-5700, Low)

This update also fixes a number of non-security related bugs.
For details, please visit the referenced advisories.

All Red Hat Enterprise Linux 4 users should upgrade to these updated
packages, which contain backported patches to resolve these issues. The
system must be rebooted for this update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0331.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0331";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-hugemem-devel", rpm:"kernel-hugemem-devel~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-largesmp", rpm:"kernel-largesmp~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-largesmp-devel", rpm:"kernel-largesmp-devel~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~78.0.17.EL", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
