# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0382 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63586);
 script_cve_id("CVE-2008-5086", "CVE-2009-0036");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0382";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0382.

libvirt is a C API for managing and interacting with the virtualization
capabilities of Linux and other operating systems. libvirt also provides
tools for remotely managing virtualized systems.

The libvirtd daemon was discovered to not properly check user connection
permissions before performing certain privileged actions, such as
requesting migration of an unprivileged guest domain to another system. A
local user able to establish a read-only connection to libvirtd could use
this flaw to perform actions that should be restricted to read-write
connections. (CVE-2008-5086)

libvirt_proxy, a setuid helper application allowing non-privileged users to
communicate with the hypervisor, was discovered to not properly validate
user requests. Local users could use this flaw to cause a stack-based
buffer overflow in libvirt_proxy, possibly allowing them to run arbitrary
code with root privileges. (CVE-2009-0036)

All users are advised to upgrade to these updated packages, which contain
backported patches which resolve these issues. After installing the update,
libvirtd must be restarted manually (for example, by issuing a
service libvirtd restart command) for this change to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0382.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0382";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.3.3~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-debuginfo", rpm:"libvirt-debuginfo~0.3.3~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.3.3~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-python", rpm:"libvirt-python~0.3.3~14.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
