# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 006-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53562);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 006-1 (zope)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to zope
announced via advisory DSA 006-1.

Last week a Zope (security advisory was released which indicated
Erik Enge found a problem in the way Zope calculates roles. In some
situations Zope checked the wrong folder hierarchy which could
cause it to grant local roles when it should not. In other words:
users with privileges in one folder could gain privileges in
another folder.

This has been fixed in version 2.1.6-5.3 by including the
2000-12-15 hotfix, and we recommend that you upgrade your zope


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20006-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 006-1 (zope)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zope", ver:"2.1.6-5.3", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
