# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 081-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53759);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 081-1 (w3m, w3m-ssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to w3m, w3m-ssl
announced via advisory DSA 081-1.

In SNS Advisory No. 32 a buffer overflow vulnerability has been
reported in the routine which parses MIME headers that are returned
from web servers.  A malicious web server administrator could exploit
this and let the client web browser execute arbitrary code.

W3m handles MIME headers included in the request/response message of
HTTP communication like any other we bbrowser.  A buffer overflow will
be occur when w3m receives a MIME encoded header with base64 format.

This problem has been fixed by the maintainer in version
0.1.10+0.1.11pre+kokb23-4 of w3m and w3m-ssl (for the SSL-enabled
version), both for Debian GNU/Linux 2.2.

We recommend that you upgrade your w3m packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20081-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 081-1 (w3m, w3m-ssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"w3m", ver:"0.1.10+0.1.11pre+kokb23-4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"w3m-ssl", ver:"0.1.10+0.1.11pre+kokb23-4", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
