# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 108-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53388);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 108-1 (wmtv)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to wmtv
announced via advisory DSA 108-1.

Nicolas Boullis found some security problems in the wmtv package (a
dockable video4linux TV player for windowmaker) which is distributed
in Debian GNU/Linux 2.2.  With the current version of wmtv, the
configuration file is written back as the superuser, and without any
further checks.  A mailicious user might use that to damage important
files

This problem has been fixed in version 0.6.5-2potato2 for the stable
distribution by dropping privileges as soon as possible and only
regaining them where required.  In the current testing/unstable
distribution this problem has been fixed in version 0.6.5-9 and above
by not requiring privileges anymore.  Both contain fixes for two
potential buffer overflows as well.

We recommend that you upgrade your wmtv packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20108-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 108-1 (wmtv)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wmtv", ver:"0.6.5-2potato2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
