# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1188-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57482);
 script_cve_id("CVE-2006-3636", "CVE-2006-4624");
 script_bugtraq_id(19831);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1188-1 (mailman)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mailman
announced via advisory DSA 1188-1.

Several security related problems have been discovered in mailman, the
web-based GNU mailing list manager.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2006-3636

Moritz Naumann discovered several cross-site scripting problems
that could allow remote attackers to inject arbitrary web script
or HTML.

CVE-2006-4624

Moritz Naumann discovered that a remote attacker can inject
arbitrary strings into the logfile.

For the stable distribution (sarge) this problem has been fixed in
version 2.1.5-8sarge5.

For the unstable distribution (sid) this problem has been fixed in
version 2.1.8-3.

We recommend that you upgrade your mailman package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201188-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1188-1 (mailman)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mailman", ver:"2.1.5-8sarge5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
