# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1364-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58584);
 script_cve_id("CVE-2007-2438", "CVE-2007-2953");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1364-1 (vim)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to vim
announced via advisory DSA 1364-1.

Several vulnerabilities have been discovered in the vim editor. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-2953

Ulf Harnhammar discovered that a format string flaw in helptags_one() from
src/ex_cmds.c (triggered through the helptags command) can lead to the
execution of arbitrary code.

CVE-2007-2438

Editors often provide a way to embed editor configuration commands (aka
modelines) which are executed once a file is opened. Harmful commands
are filtered by a sandbox mechanism. It was discovered that function
calls to writefile(), feedkeys() and system() were not filtered, allowing
shell command execution with a carefully crafted file opened in vim.

For the oldstable distribution (sarge) these problems have been fixed in
version 6.3-071+1sarge2. Sarge is not affected by CVE-2007-2438.

For the stable distribution (etch) these problems have been fixed
in version 7.0-122+1etch3.

For the unstable distribution (sid) these problems have been fixed in
version 7.1-056+1.

We recommend that you upgrade your vim packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201364-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1364-1 (vim)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"vim-common", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-doc", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-full", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gnome", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gtk", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-lesstif", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-perl", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-python", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-ruby", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-tcl", ver:"6.3-071+1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-doc", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gui-common", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-runtime", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-common", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-full", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gnome", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-gtk", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-lesstif", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-perl", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-python", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-ruby", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-tcl", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vim-tiny", ver:"7.0-122+1etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
