# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1376-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58614);
 script_cve_id("CVE-2007-4569");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1376-1 (kdebase)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdebase
announced via advisory DSA 1376-1.


iKees Huijgen discovered that under certain circumstances KDM, an X
session manage for KDE, it is possible for KDM to be tricked into
allowing user logins without a password.

For the stable distribution (etch), this problem has been fixed in version
4:3.5.5a.dfsg.1-6etch1.

For the old stable distribution (sarge), this problem was not present.

We recommend that you upgrade your kdebase package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201376-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1376-1 (kdebase)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdebase", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-data", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-doc-html", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-doc", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmenuedit", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpersonalizer", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcontrol", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdesktop", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"khelpcenter", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkonq4", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kicker", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-dbg", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdm", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpager", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksplash", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klipper", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kate", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdepasswd", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konqueror", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konsole", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksysguard", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-bin", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ktip", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfind", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-dev", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksysguardd", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-kio-plugins", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kwin", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkonq4-dev", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksmserver", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konqueror-nsplugins", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kappfinder", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdeprint", ver:"3.5.5a.dfsg.1-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
