# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1452-1 (wzdftpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60107);
 script_cve_id("CVE-2007-5300");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1452-1 (wzdftpd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to wzdftpd
announced via advisory DSA 1452-1.

k1tk4t discovered that wzdftpd, a portable, modular, small and efficient
ftp server, did not correctly handle the receipt of long usernames.  This
could allow remote users to cause the daemon to exit.

For the stable distribution (etch), this problem has been fixed in version
0.8.1-2etch1.

For the old stable distribution (sarge), this problem has been fixed in
version 0.5.2-1.1sarge3.

For the unstable distribution (sid), this problem has been fixed in version
0.8.2-2.1.

We recommend that you upgrade your wzdftpd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201452-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1452-1 (wzdftpd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wzdftpd-dev", ver:"0.5.2-1.1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-mod-perl", ver:"0.5.2-1.1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-back-mysql", ver:"0.5.2-1.1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd", ver:"0.5.2-1.1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-mod-tcl", ver:"0.5.2-1.1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-back-mysql", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-mod-tcl", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-back-pgsql", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-mod-avahi", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-dev", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wzdftpd-mod-perl", ver:"0.8.1-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
