# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 149-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53423);
 script_bugtraq_id(5356);
 script_cve_id("CVE-2002-0391");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 149-2 (glibc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to glibc
announced via advisory DSA 149-2.

Wolfram Gloger discovered that the bugfix from DSA 149-1 unintentially
replaced potential integer overflows in connection with malloc() with
more likely divisions by zero.  This called for an update.  For
completeness the original security advisory said:

An integer overflow bug has been discovered in the RPC library used
by GNU libc, which is derived from the SunRPC library.  This bug
could be exploited to gain unauthorized root access to software
linking to this code.  The packages below also fix integer overflows
in the malloc code.

This is fixed in version 2.2.5-11.2 for the current stable
distribution (woody) by using a patch from the stable glibc-2_2 branch
by Wolfgang and in version 2.1.3-24 for the old stable release
(potato).

We recommend that you upgrade your libc6 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20149-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 149-2 (glibc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"glibc-doc", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"i18ndata", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dbg", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dev", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-pic", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-prof", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss1-compat", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nscd", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dbg", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-pic", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-prof", ver:"2.1.3-24", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"glibc-doc", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dbg", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dev", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-pic", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-prof", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nscd", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dbg", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-pic", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-prof", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-sparc64", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-sparc64", ver:"2.2.5-11.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
