# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1500-1 (splitvt)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60434);
 script_cve_id("CVE-2008-0162");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1500-1 (splitvt)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to splitvt
announced via advisory DSA 1500-1.

Mike Ashton discovered that splitvt, a utility to run two programs in a
split screen, did not drop group privileges prior to executing 'xprop'.
This could allow any local user to gain the privileges of group utmp.

For the stable distribution (etch), this problem has been fixed in version
1.6.5-9etch1.

For the unstable distribution (sid), this problem has been fixed in
version 1.6.6-4.

We recommend that you upgrade your splitvt package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201500-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1500-1 (splitvt)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"splitvt", ver:"1.6.5-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
