# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1543-1 (vlc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60789);
 script_cve_id("CVE-2007-6681", "CVE-2007-6682", "CVE-2007-6683", "CVE-2008-0295", "CVE-2008-0296", "CVE-2008-0073", "CVE-2008-0984", "CVE-2008-1489");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1543-1 (vlc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to vlc
announced via advisory DSA 1543-1.

Luigi Auriemma, Alin Rad Pop, Rémi Denis-Courmont, Quovodis, Guido
Landi, Felipe Manzano, Anibal Sacco and others discovered multiple
vulnerabilities in vlc, an application for playback and streaming of
audio and video.  In the worst case, these weaknesses permit a remote,
unauthenticated attacker to execute arbitrary code with the privileges
of the user running vlc.

The Common Vulnerabilities and Exposures project identifies the
following eight problems:

CVE-2007-6681

A buffer overflow vulnerability in subtitle handling allows an
attacker to execute arbitrary code through the opening of a
maliciously crafted MicroDVD, SSA or Vplayer file.

CVE-2007-6682

A format string vulnerability in the HTTP-based remote control
facility of the vlc application allows a remote, unauthenticated
attacker to execute arbitrary code.

CVE-2007-6683

Insecure argument validation allows a remote attacker to overwrite
arbitrary files writable by the user running vlc, if a maliciously
crafted M3U playlist or MP3 audio file is opened.

CVE-2008-0295, CVE-2008-0296

Heap buffer overflows in RTSP stream and session description
protocol (SDP) handling allow an attacker to execute arbitrary
code if a maliciously-crafted RTSP stream is played.

CVE-2008-0073

Insufficient integer bounds checking in SDP handling allows the
execution of arbitrary code through a maliciously crafted SDP
stream ID parameter in an RTSP stream.

CVE-2008-0984

Insufficient integrity checking in the MP4 demuxer allows a remote
attacker to overwrite arbitrary memory and execute arbitrary code
if a maliciously-crafted MP4 file is opened.

CVE-2008-1489

An integer overflow vulnerability in MP4 handling allows a remote
attacker to cause a heap buffer overflow, inducing a crash and
possibly the execution of arbitrary code if a maliciously-crafted
MP4 file is opened.

For the stable distribution (etch), these problems have been fixed in
version 0.8.6-svn20061012.debian-5.1+etch2.

For the unstable distribution (sid), these problems have been fixed in
version 0.6.8.e-2.

We recommend that you upgrade your vlc packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201543-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1543-1 (vlc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"vlc-plugin-alsa", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wxvlc", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-sdl", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-arts", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvlc0-dev", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-plugin-vlc", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-nox", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-esd", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvlc0", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-ggi", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-svgalib", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vlc-plugin-glide", ver:"0.8.6-svn20061012.debian-5.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
