# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1613-1 (libgd2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61363);
 script_cve_id("CVE-2007-3476", "CVE-2007-3477", "CVE-2007-3996", "CVE-2007-2445");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1613-1 (libgd2)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libgd2
announced via advisory DSA 1613-1.

Multiple vulnerabilities have been identified in libgd2, a library
for programmatic graphics creation and manipulation.  The Common
Vulnerabilities and Exposures project identifies the following three
issues:

CVE-2007-2445

Grayscale PNG files containing invalid tRNS chunk CRC values
could cause a denial of service (crash), if a maliciously
crafted image is loaded into an application using libgd.

CVE-2007-3476

An array indexing error in libgd's GIF handling could induce a
denial of service (crash with heap corruption) if exceptionally
large color index values are supplied in a maliciously crafted
GIF image file.

CVE-2007-3477

The imagearc() and imagefilledarc() routines in libgd allow
an attacker in control of the parameters used to specify
the degrees of arc for those drawing functions to perform
a denial of service attack (excessive CPU consumption).

CVE-2007-3996

Multiple integer overflows exist in libgd's image resizing and
creation routines; these weaknesses allow an attacker in control
of the parameters passed to those routines to induce a crash or
execute arbitrary code with the privileges of the user running
an application or interpreter linked against libgd2.

For the stable distribution (etch), these problems have been fixed in
version 2.0.33-5.2etch1.  For the unstable distribution (sid), the
problem has been fixed in version 2.0.35.dfsg-1.

We recommend that you upgrade your libgd2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201613-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1613-1 (libgd2)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgd2-xpm-dev", ver:"2.0.33-5.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd-tools", ver:"2.0.33-5.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-xpm", ver:"2.0.33-5.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-noxpm", ver:"2.0.33-5.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-noxpm-dev", ver:"2.0.33-5.2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
