# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1632-1 (tiff)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61589);
 script_cve_id("CVE-2008-2327");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1632-1 (tiff)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tiff
announced via advisory DSA 1632-1.

Drew Yao discovered that libTIFF, a library for handling the Tagged Image
File Format, is vulnerable to a programming error allowing malformed
tiff files to lead to a crash or execution of arbitrary code.

For the stable distribution (etch), this problem has been fixed in
version 3.8.2-7+etch1.

For the testing distribution (lenny), this problem has been fixed in
version 3.8.2-10+lenny1.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your tiff package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201632-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1632-1 (tiff)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff4", ver:"3.8.2-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.8.2-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.8.2-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.8.2-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.8.2-7+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
