# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1656-1 (cupsys)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61778);
 script_cve_id("CVE-2008-3639", "CVE-2008-3640", "CVE-2008-3641");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1656-1 (cupsys)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to cupsys
announced via advisory DSA 1656-1.

Several local vulnerabilities have been discovered in the Common UNIX
Printing System. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-3639

It was discovered that insufficient bounds checking in the SGI
image filter may lead to the execution of arbitrary code.

CVE-2008-3640

It was discovered that an integer overflow in the Postscript
conversion tool texttops may lead to the execution of arbitrary
code.

CVE-2008-3641

It was discovered that insufficient bounds checking in the HPGL
filter may lead to the execution of arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 1.2.7-4etch5.

For the unstable distribution (sid) and the upcoming stable distribution
(lenny), these problems have been fixed in version 1.3.8-1lenny2 of
the source package cups.

We recommend that you upgrade your cupsys package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201656-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1656-1 (cupsys)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cupsys-common", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-gnutls10", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-dbg", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsimage2-dev", ver:"1.2.7-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
