# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1667-1 (python2.4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61905);
 script_cve_id("CVE-2008-2315", "CVE-2008-3142", "CVE-2008-3143", "CVE-2008-3144");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1667-1 (python2.4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to python2.4
announced via advisory DSA 1667-1.

Several vulnerabilities have been discovered in the interpreter for the
Python language. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-2315

David Remahl discovered several integer overflows in the
stringobject, unicodeobject,  bufferobject, longobject,
tupleobject, stropmodule, gcmodule, and mmapmodule modules.

CVE-2008-3142

Justin Ferguson discovered that incorrect memory allocation in
the unicode_resize() function can lead to buffer overflows.

CVE-2008-3143

Several integer overflows were discovered in various Python core
modules.

CVE-2008-3144

Several integer oberflows were discovered in the PyOS_vsnprintf()
function.

For the stable distribution (etch), these problems have been fixed in
version 2.4.4-3+etch2.

For the unstable distribution (sid) and the upcoming stable
distribution (lenny), these problems have been fixed in
version 2.4.5-5.

We recommend that you upgrade your python2.4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201667-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1667-1 (python2.4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4", ver:"2.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.4-3+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
