# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1749-1 (linux-2.6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63681);
 script_cve_id("CVE-2009-0029", "CVE-2009-0031", "CVE-2009-0065", "CVE-2009-0269", "CVE-2009-0322", "CVE-2009-0676", "CVE-2009-0675", "CVE-2009-0745", "CVE-2009-0746", "CVE-2009-0747", "CVE-2009-0748");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1749-1 (linux-2.6)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to linux-2.6
announced via advisory DSA 1749-1.

Several vulnerabilities have been discovered in the Linux kernel that
may lead to a denial of service or privilege escalation. The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2009-0029

Christian Borntraeger discovered an issue effecting the alpha,
mips, powerpc, s390 and sparc64 architectures that allows local
users to cause a denial of service or potentially gain elevated
privileges.

CVE-2009-0031

Vegard Nossum discovered a memory leak in the keyctl subsystem
that allows local users to cause a denial of service by consuming
all of kernel memory.

CVE-2009-0065

Wei Yongjun discovered a memory overflow in the SCTP
implementation that can be triggered by remote users.

CVE-2009-0269

Duane Griffin provided a fix for an issue in the eCryptfs
subsystem which allows local users to cause a denial of service
(fault or memory corruption).

CVE-2009-0322

Pavel Roskin provided a fix for an issue in the dell_rbu driver
that allows a local user to cause a denial of service (oops) by
reading 0 byts from a sysfs entry.

CVE-2009-0676

Clement LECIGNE discovered a bug in the sock_getsockopt function
that may result in leaking sensitive kernel memory.

CVE-2009-0675

Roel Kluin discovered inverted logic in the skfddi driver that
permits local, unprivileged users to reset the driver statistics.

CVE-2009-0745

Peter Kerwien discovered an issue in the ext4 filesystem that
allows local users to cause a denial of service (kernel oops)
during a resize operation.

CVE-2009-0746

Sami Liedes reported an issue in the ext4 filesystem that allows
local users to cause a denial of service (kernel oops) when
accessing a specially crafted corrupt filesystem.

CVE-2009-0747

David Maciejak reported an issue in the ext4 filesystem that
allows local users to cause a denial of service (kernel oops) when
mounting a specially crafted corrupt filesystem.

CVE-2009-0748

David Maciejak reported an additional issue in the ext4 filesystem
that allows local users to cause a denial of service (kernel oops)
when mounting a specially crafted corrupt filesystem.

For the stable distribution (lenny), these problems have been fixed in
version 2.6.26-13lenny2.

For the oldstable distribution (etch), these problems, where applicable,
will be fixed in future updates to linux-2.6 and linux-2.6.24.

We recommend that you upgrade your linux-2.6 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201749-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1749-1 (linux-2.6)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-support-2.6.26-1", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.26", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.26", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-doc-2.6.26", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-tree-2.6.26", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.26", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-alpha-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-alpha-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-common", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-alpha-generic", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-alpha-legacy", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-alpha", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-alpha-generic", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-alpha-legacy", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-xen-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-openvz-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-common-openvz", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-common-vserver", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-xen-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-1-xen-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-1-xen-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-common-xen", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-openvz-amd64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-footbridge", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-orion5x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-orion5x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-ixp4xx", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-iop32x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-arm", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-ixp4xx", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-iop32x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-footbridge", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-versatile", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-armel", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-versatile", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-parisc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-parisc-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-hppa", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-parisc64-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-parisc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-parisc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-parisc-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-parisc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-parisc64-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-686-bigmem", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-openvz-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-686-bigmem", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-686-bigmem", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-xen-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-1-xen-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-686-bigmem", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-1-xen-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-xen-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-i386", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-486", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-486", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-openvz-686", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-itanium", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-mckinley", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-mckinley", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-itanium", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-mckinley", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-ia64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-itanium", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-itanium", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-mckinley", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-4kc-malta", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-sb1-bcm91250a", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-r5k-ip32", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-mips", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-sb1a-bcm91480b", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-r4k-ip22", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-5kc-malta", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-r4k-ip22", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-sb1-bcm91250a", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-sb1a-bcm91480b", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-r5k-ip32", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-4kc-malta", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-5kc-malta", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-mipsel", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-r5k-cobalt", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-r5k-cobalt", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-powerpc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-powerpc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-powerpc-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-powerpc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-powerpc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-powerpc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-powerpc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-powerpc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-powerpc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-powerpc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-powerpc-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-s390x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-s390x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-s390", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-s390", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-s390x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-s390", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-s390-tape", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-s390x", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-vserver-sparc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-all-sparc", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-sparc64-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-sparc64-smp", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-1-sparc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-vserver-sparc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-1-sparc64", ver:"2.6.26-13lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
