# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 184-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53434);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 184-1 (krb4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to krb4
announced via advisory DSA 184-1.

Tom Yu and Sam Hartman of MIT discovered another stack buffer overflow
in the kadm_ser_wrap_in function in the Kerberos v4 administration
server.  This kadmind bug has a working exploit code circulating,
hence it is considered serious.

This problem has been fixed in version 1.1-8-2.2 for the current
stable distribution (woody), in version 1.0-2.2 for the old stable
distribution (potato) and in version 1.1-11-8 for the unstable
distribution (sid).

We recommend that you upgrade your krb4 packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20184-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 184-1 (krb4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kerberos4kth-clients", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-dev", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-kdc", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-services", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-user", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-x11", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth1", ver:"1.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-docs", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-services", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-user", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-x11", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth1", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-clients", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-clients-x", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-dev", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-dev-common", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-kdc", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-kip", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-servers", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kerberos4kth-servers-x", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libacl1-kerberos4kth", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm1-kerberos4kth", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkdb-1-kerberos4kth", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb-1-kerberos4kth", ver:"1.1-8-2.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
