# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 210-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53858);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 210-1 (lynx, lynx-ssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to lynx, lynx-ssl
announced via advisory DSA 210-1.

lynx (a text-only web browser) did not properly check for illegal
characters in all places, including processing of command line options,
which could be used to insert extra HTTP headers in a request.

For Debian GNU/Linux 2.2/potato this has been fixed in version 2.8.3-1.1
of the lynx package and version 2.8.3.1-1.1 of the lynx-ssl package.

For Debian GNU/Linux 3.0/woody this has been fixed in version 2.8.4.1b-3.2
of the lynx package and version 1:2.8.4.1b-3.1 of the lynx-ssl package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20210-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 210-1 (lynx, lynx-ssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lynx-ssl", ver:"2.8.3.1-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lynx", ver:"2.8.3-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lynx", ver:"2.8.4.1b-3.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lynx-ssl", ver:"2.8.4.1b-3.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
