# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 254-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53723);
 script_cve_id("CVE-2002-1051", "CVE-2002-1364", "CVE-2002-1386", "CVE-2002-1387");
 script_bugtraq_id(4956,6166,6274,6275);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 254-1 (traceroute-nanog)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to traceroute-nanog
announced via advisory DSA 254-1.

A vulnerability has been discovered in NANOG traceroute, an enhanced
version of the Van Jacobson/BSD traceroute program.  A buffer overflow
occurs in the 'get_origin()' function.  Due to insufficient bounds
checking performed by the whois parser, it may be possible to corrupt
memory on the system stack.  This vulnerability can be exploited by a
remote attacker to gain root privileges on a target host.  Though,
most probably not in Debian.

The Common Vulnerabilities and Exposures (CVE) project additionally
identified the following vulnerabilities which were already fixed in
the Debian version in stable (woody) and oldstable (potato) and are
mentioned here for completeness (and since other distributions had to
release a separate advisory for them):

* CVE-2002-1364 (BugTraq ID 6166) talks about a buffer overflow in
the get_origin function which allows attackers to execute arbitrary
code via long WHOIS responses.

* CVE-2002-1051 (BugTraq ID 4956) talks about a format string
vulnerability that allows local users to execute arbitrary code via
the -T (terminator) command line argument.

* CVE-2002-1386 talks about a buffer overflow that may allow local
users to execute arbitrary code via a long hostname argument.

* CVE-2002-1387 talks about the spray mode that may allow local users
to overwrite arbitrary memory locations.

Fortunately, the Debian package drops privileges quite early after
startup, so those problems aer not likely to result in an exploit on a
Debian machine.

For the current stable distribution (woody) the above problem has been
fixed in version 6.1.1-1.2.

For the old stable distribution (potato) the above problem has been
fixed in version 6.0-2.2.

For the unstable distribution (sid) these problems have been fixed in
version 6.3.0-1.

We recommend that you upgrade your traceroute-nanog package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20254-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 254-1 (traceroute-nanog)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"traceroute-nanog", ver:"6.0-2.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"traceroute-nanog", ver:"6.1.1-1.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
