# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 272-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53343);
 script_cve_id("CVE-2003-0028");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 272-1 (dietlibc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to dietlibc
announced via advisory DSA 272-1.

eEye Digital Security discovered an integer overflow in the
xdrmem_getbytes() function of glibc, that is also present in dietlibc,
a small libc useful especially for small and embedded systems.  This
function is part of the XDR encoder/decoder derived from Sun's RPC
implementation.  Depending upon the application, this vulnerability
can cause buffer overflows and could possibly be exploited to execute
arbitray code.

For the stable distribution (woody) this problem has been
fixed in version 0.12-2.5.

The old stable distribution (potato) does not contain dietlibc
packages.

For the unstable distribution (sid) this problem has been
fixed in version 0.22-2.

We recommend that you upgrade your dietlibc packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20272-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 272-1 (dietlibc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dietlibc-doc", ver:"0.12-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dietlibc-dev", ver:"0.12-2.5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
