# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 323-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53612);
 script_cve_id("CVE-2003-0381");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 323-1 (noweb)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to noweb
announced via advisory DSA 323-1.

Jakob Lell discovered a bug in the 'noroff' script included in noweb
whereby a temporary file was created insecurely.  During a review,
several other instances of this problem were found and fixed.  Any of
these bugs could be exploited by a local user to overwrite arbitrary
files owned by the user invoking the script.

For the stable distribution (woody) these problems have been fixed in
version 2.9a-7.3.

For old stable distribution (potato) this problem has been fixed in
version 2.9a-5.1.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you update your noweb package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20323-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 323-1 (noweb)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nowebm", ver:"2.9a-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nowebm", ver:"2.9a-7.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
