# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 326-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53615);
 script_bugtraq_id(7988);
 script_cve_id("CVE-2003-0441");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 326-1 (orville-write)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to orville-write
announced via advisory DSA 326-1.

Orville Write, a replacement for the standard write(1) command,
contains a number of buffer overflows.  These could be exploited to
gain either gid tty or root privileges, depending on the configuration
selected when the package is installed.

For the stable distribution (woody) this problem has been fixed in
version 2.53-4woody1.

The old stable distribution (potato) does not contain an orville-write
package.

For the unstable distribution (sid) this problem will be fixed soon.
See Debian bug report #170747.

We recommend that you update your orville-write package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20326-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 326-1 (orville-write)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"orville-write", ver:"2.53-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
