# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 388-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53672);
 script_cve_id("CVE-2003-0690", "CVE-2003-0692");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 388-1 (kdebase)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdebase
announced via advisory DSA 388-1.

Two vulnerabilities were discovered in kdebase:

- CVE-2003-0690

KDM in KDE 3.1.3 and earlier does not verify whether the pam_setcred
function call succeeds, which may allow attackers to gain root
privileges by triggering error conditions within PAM modules, as
demonstrated in certain configurations of the MIT pam_krb5 module.

- CVE-2003-0692

KDM in KDE 3.1.3 and earlier uses a weak session cookie generation
algorithm that does not provide 128 bits of entropy, which allows
attackers to guess session cookies via brute force methods and gain
access to the user session.

These vulnerabilities are described in the following security
advisory from KDE:

http://www.kde.org/info/security/advisory-20030916-1.txt

For the current stable distribution (woody) these problems have been
fixed in version 4:2.2.2-14.7.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you update your kdebase package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20388-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 388-1 (kdebase)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdebase-doc", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdewallpapers", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kate", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-audiolibs", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-dev", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-libs", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdm", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konqueror", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konsole", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kscreensaver", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkonq-dev", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkonq3", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
