# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 488-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53182);
 script_bugtraq_id(10162);
 script_cve_id("CVE-2004-0404");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 488-1 (logcheck)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to logcheck
announced via advisory DSA 488-1.

Christian Jaeger reported a bug in logcheck which could potentially be
exploited by a local user to overwrite files with root privileges.
logcheck utilized a temporary directory under /var/tmp without taking
security precautions.  While this directory is created when logcheck
is installed, and while it exists there is no vulnerability, if at
any time this directory is removed, the potential for exploitation exists.

For the current stable distribution (woody) this problem has been
fixed in version 1.1.1-13.1woody1.

For the unstable distribution (sid), this problem has been fixed in
version 1.1.1-13.2.

We recommend that you update your logcheck package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20488-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 488-1 (logcheck)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"logcheck-database", ver:"1.1.1-13.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"logcheck", ver:"1.1.1-13.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"logtail", ver:"1.1.1-13.1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
